# -*- coding: utf-8 -*-
#
# CKAN documentation build configuration file, created by
# sphinx-quickstart on Sun Oct 25 16:47:17 2009.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# The contents of this file are pickled, so don't put values in the namespace
# that aren't pickleable (module imports are okay, they're removed automatically).
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

from datetime import date
import re
import os
import subprocess

from packaging.version import parse as version_parse, VERSION_PATTERN

import ckan

# If your extensions (or modules documented by autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#sys.path.append(os.path.abspath('.'))

# General configuration
# ---------------------

rst_epilog = '''

.. |virtualenv_parent_dir| replace:: /usr/lib/ckan
.. |virtualenv| replace:: |virtualenv_parent_dir|/default
.. |activate| replace:: . |virtualenv|/bin/activate
.. |config_parent_dir| replace:: /etc/ckan
.. |config_dir| replace:: |config_parent_dir|/default
.. |production.ini| replace:: |config_dir|/production.ini
.. |development.ini| replace:: |config_dir|/development.ini
.. |ckan.ini| replace:: |config_dir|/ckan.ini
.. |git_url| replace:: \https://github.com/ckan/ckan.git
.. |raw_git_url| replace:: \https://raw.githubusercontent.com/ckan/ckan
.. |postgres| replace:: PostgreSQL
.. |database| replace:: ckan_default
.. |database_user| replace:: ckan_default
.. |datastore| replace:: datastore_default
.. |datastore_user| replace:: datastore_default
.. |test_database| replace:: ckan_test
.. |test_datastore| replace:: datastore_test
.. |apache_config_file| replace:: /etc/apache2/sites-available/ckan_default.conf
.. |apache.wsgi| replace:: |config_dir|/apache.wsgi
.. |wsgi.py| replace:: |config_dir|/wsgi.py
.. |data_dir| replace:: |config_dir|/data
.. |sstore| replace:: |config_dir|/sstore
.. |storage_parent_dir| replace:: /var/lib/ckan
.. |storage_dir| replace:: |storage_parent_dir|/default
.. |storage_path| replace:: |storage_parent_dir|/default
.. |restart_uwsgi| replace:: sudo supervisorctl restart ckan-uwsgi:*
.. |solr| replace:: Solr
.. |restructuredtext| replace:: reStructuredText
.. |nginx| replace:: Nginx
.. |sqlite| replace:: SQLite
.. |python| replace:: Python
.. |sqlalchemy| replace:: SQLAlchemy
.. |javascript| replace:: JavaScript
.. |apache| replace:: Apache
.. |nginx_config_file| replace:: /etc/nginx/sites-available/ckan
.. |reload_nginx| replace:: sudo service nginx reload
.. |restart_nginx| replace:: sudo service nginx restart
.. |jquery| replace:: jQuery
.. |nodejs| replace:: Node.js

.. _Jinja2: http://jinja.pocoo.org/
.. _CKAN front page: http://127.0.0.1:5000
.. _bootstrap: http://getbootstrap.com/2.3.2/
.. _CKAN issue tracker: https://github.com/ckan/ckan/issues

'''

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    'sphinx.ext.autodoc', 'sphinx.ext.todo',
    'sphinx.ext.autosummary', 'ckan.plugins.toolkit_sphinx_extension',
    'sphinx_rtd_theme', 'sphinx.ext.extlinks',
]
html_theme = 'sphinx_rtd_theme'
autodoc_member_order = 'bysource'
todo_include_todos = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = {'.rst': 'restructuredtext'}

# The encoding of source files.
#source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'contents'

# General information about the project.
project = u'CKAN'
project_short_name = u'CKAN'
copyright = u'&copy; 2009-{} '.format(date.today().strftime("%Y"))
copyright += u'''<a href="https://okfn.org/">Open Knowledge Foundation</a> and
    <a href="https://github.com/ckan/ckan/graphs/contributors">contributors</a>.
    Licensed under <a
    href="https://creativecommons.org/licenses/by-sa/3.0/">Creative Commons
    Attribution ShareAlike (Unported) v3.0 License</a>.<br />
    <img src="https://licensebuttons.net/l/by-sa/3.0/80x15.png" alt="CC License Logo" />
    <a href="https://opendefinition.org/">
      <img src="https://assets.okfn.org/images/ok_buttons/oc_80x15_blue.png" border="0"
      alt="{{ _('Open Content') }}" />
    </a>
  '''
html_show_sphinx = False

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = ckan.__version__.rstrip('abcdefgh')
# The full version, including alpha/beta/rc tags.
release = ckan.__version__
version_re = None
point_releases_ = None

SUPPORTED_CKAN_VERSIONS = 2

def extract_version(tag):
    """ Ensure we only work with 'valid' ckan tagged releases"""
    _regex = re.compile(r"^\s*ckan-" + VERSION_PATTERN + r"\s*$", re.VERBOSE | re.IGNORECASE)
    match = re.search(_regex, tag)
    if not match:
        return False
    else:
        return True

def get_release_tags():
    git_tags = subprocess.check_output(
        ['git', 'tag', '-l'], stderr=subprocess.STDOUT).decode('utf8')
    git_tags = git_tags.split()
    release_tags_ = [tag for tag in git_tags if extract_version(tag)]

    # git tag -l prints out the tags in the right order anyway, but don't rely
    # on that, sort them again here for good measure.
    release_tags_ = sorted(release_tags_, key=lambda tag: version_parse(tag.lstrip('ckan-')))
    return release_tags_


def get_equivalent_point_release(version_):
    '''Returns the equivalent point release of any given version.

    e.g.
        ckan-2.1.3 -> ckan-2.1
        ckan-2.1   -> ckan-2.1  (the occasion when we didn't do semver)
    '''
    version = version_parse(version_.lstrip("ckan-"))
    return f"ckan-{version.major}.{version.minor}"


def get_point_releases():
    '''
    returns ['ckan-1.3', 'ckan-1.4', ... 'ckan-2.0', 'ckan-2.1', ...]
    '''
    global point_releases_
    if point_releases_ is None:
        releases = get_release_tags()
        point_releases_ = []
        for release in releases:
            point_release = get_equivalent_point_release(release)
            if point_release not in point_releases_:
                point_releases_.append(point_release)
    return point_releases_


def get_status_of_this_version():
    '''Returns whether this release is supported or another category.
    '''
    equiv_point_release = get_equivalent_point_release(version)
    point_releases_ = get_point_releases()
    supported_point_releases = point_releases_[-int(SUPPORTED_CKAN_VERSIONS):]
    if equiv_point_release in supported_point_releases:
        return 'supported'
    else:
        return 'unsupported'


def get_current_release_tag():
    ''' Return the name of the tag for the current release

    e.g.: "ckan-2.7.4"

    '''
    release_tags_ = get_release_tags()

    current_tag = "ckan-{}".format(version)

    if release_tags_.__contains__(current_tag):
        return current_tag
    else:
        # Un-released tag (eg master or a beta version), use the latest one
        return get_latest_release_tag()


def get_latest_release_tag():
    '''Return the name of the git tag for the latest stable release.

    e.g.: "ckan-2.7.4"

    This requires git to be installed.

    '''
    release_tags_ = get_release_tags()

    if release_tags_:
        return release_tags_[-1]
    else:
        # Un-released tag (eg master or a beta version), use the latest one
        return get_latest_release_version()


def get_latest_release_version():
    '''Return the version number of the latest stable release.

    e.g. "2.1.1"

    '''
    version = get_latest_release_tag()[len('ckan-'):]

    # TODO: We could assert here that latest_version matches X.Y.Z.

    return version


def get_current_release_version():
    '''Return the version number of the current release.

    e.g. "2.1.1"

    '''
    version = get_current_release_tag()[len('ckan-'):]

    # TODO: We could assert here that latest_version matches X.Y.Z.

    return version


def get_previous_release_version() -> str:
    """Returns the version number of the previous release

    eg if the latest release is 2.9.5, it returns 2.8.10

    """
    current_version = version_parse(get_current_release_version())

    previous_tag_prefix = f"ckan-{current_version.major}.{current_version.minor - 1}"

    previous_version_tags = [
        r for r in get_release_tags() if r.startswith(previous_tag_prefix)
    ]
    previous_release_version = previous_version_tags[-1][len("ckan-"):]
    return previous_release_version


def get_latest_package_name(distro, py_version=None):
    '''Return the filename of the Ubuntu package for the latest stable release.

    e.g. "python-ckan_2.1-trusty_amd64.deb"

    If ``py_version`` is provided, it's added as part of the iter number:

    e.g. "python-ckan_2.9-py3-focal_amd64.deb"

    '''
    # We don't create a new package file name for a patch release like 2.1.1,
    # instead we just update the existing 2.1 package. So package names only
    # have the X.Y part of the version number in them, not X.Y.Z.
    version = get_latest_release_version()
    latest_minor_version = version[:version.find(".", 3)]

    if py_version:
        name = 'python-ckan_{version}-py{py_version}-{distro}_amd64.deb'.format(
            version=latest_minor_version, distro=distro, py_version=py_version)
    else:
        name = 'python-ckan_{version}-{distro}_amd64.deb'.format(
            version=latest_minor_version, distro=distro)
    return name


def get_current_package_name(distro, py_version=None):
    '''Return the filename of the Ubuntu package for the current stable release.

    e.g. "python-ckan_2.1-trusty_amd64.deb"

    If ``py_version`` is provided, it's added as part of the iter number:

    e.g. "python-ckan_2.9-py3-focal_amd64.deb"

    '''
    # We don't create a new package file name for a patch release like 2.1.1,
    # instead we just update the existing 2.1 package. So package names only
    # have the X.Y part of the version number in them, not X.Y.Z.
    version = get_current_release_version()
    current_minor_version = version[:version.find(".", 3)]

    if py_version:
        name = 'python-ckan_{version}-py{py_version}-{distro}_amd64.deb'.format(
            version=current_minor_version, distro=distro, py_version=py_version)
    else:
        name = 'python-ckan_{version}-{distro}_amd64.deb'.format(
            version=current_minor_version, distro=distro)
    return name


def config_defaults_from_declaration():
    from ckan.config.declaration import Declaration
    decl = Declaration()
    decl.load_core_declaration()
    decl.load_plugin("resource_proxy")
    decl.load_plugin("text_view")
    decl.load_plugin("image_view")
    decl.load_plugin("datatables_view")
    decl.load_plugin("datastore")
    decl.load_plugin("datapusher")

    _write_config_options_file(decl)

    return {
        f"config:{k}": "``{}``".format(
            repr(decl[k].default) if decl[k].has_default() else None
        ) for k in decl.iter_options()
    }


def _write_config_options_file(decl):
    '''
    Write a file in the doc/ dir containing documentation for config options.

    '''
    filename = '_config_options.inc'
    header = '''.. Documentation for declared config options.
   **This file is autogenerated!** So don't edit it by hand.

'''
    with open(filename, 'w') as f:
        f.write(header.format(filename=filename))
        f.write(decl.into_docs())


def write_substitutions_file(**kwargs):
    '''
    Write a file in the doc/ dir containing reStructuredText substitutions.

    Any keyword argument is stored as a substitution.
    '''
    filename = '_substitutions.rst'
    header = '''

.. Some common reStructuredText substitutions.

   **This file is autogenerated!** So don't edit it by hand.

   You can include this file at the top of your ``*.rst`` file with a line
   like::

     .. include:: {filename}

   Then use the substitutions in this file, e.g.::

     |latest_release_version|

'''
    with open(filename, 'w') as f:
        f.write(header.format(filename=filename))
        for name, substitution in kwargs.items():
            f.write('.. |{name}| replace:: {substitution}\n'.format(
                    name=name, substitution=substitution))

current_release_tag_value = get_current_release_tag()
current_release_version = get_current_release_version()
previous_release_version = get_previous_release_version()
previous_release_version_format = f"**CKAN {previous_release_version}**"
current_minor_version = current_release_version[:current_release_version.find(".", 3)]
latest_release_tag_value = get_latest_release_tag()
latest_release_version = get_latest_release_version()
latest_release_version_format = f"**CKAN {latest_release_version}**"
latest_minor_version = latest_release_version[:latest_release_version.find(".", 3)]
is_master = "a" in release.split(".")[-1]
is_supported = get_status_of_this_version() == 'supported'
is_latest_version = version == latest_release_version

write_substitutions_file(
    current_release_tag=current_release_tag_value,
    current_release_version=current_release_version,
    previous_release_version=previous_release_version,
    previous_release_version_format=previous_release_version_format,
    latest_release_tag=latest_release_tag_value,
    latest_release_version=latest_release_version,
    latest_release_version_format=latest_release_version_format,
    current_package_name_jammy=get_current_package_name('jammy'),
    current_package_name_focal=get_current_package_name('focal'),
    **config_defaults_from_declaration()
)

rst_epilog += f'''
.. |current_minor_version| replace:: {current_minor_version}
'''


# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = ['.build']

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# Options for HTML output
# -----------------------


on_rtd = os.environ.get('READTHEDOCS', None) == 'True'
if not on_rtd:
    import sphinx_rtd_theme
    html_theme = 'sphinx_rtd_theme'

html_sidebars = {
    '**':  ['globaltoc.html'],
}

html_context = {
    'latest_release_tag_value': latest_release_tag_value,
    'is_master': is_master,
    'is_supported': is_supported,
    'is_latest_version': is_latest_version,
    'latest_minor_version': latest_minor_version,
}

# The style sheet to use for HTML and HTML Help pages. A file of that name
# must exist either in Sphinx' static/ path, or in one of the custom paths
# given in html_static_path.
#html_style = 'default.css'

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = "%s v%s Guide" % (project, release)

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = "%s Admin Guide" % (project_short_name)

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = 'images/favicon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_css_files = [
    'css/custom.css'
]
# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_use_modindex = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
#html_copy_source = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'CKANdoc'


# Options for LaTeX output
# ------------------------

# The paper size ('letter' or 'a4').
#latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, document class [howto/manual]).
latex_documents = [
  ('contents', 'CKAN.tex', u'CKAN documentation',
   u'CKAN contributors', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_use_modindex = True

extlinks = {'source-blob': (
    f'https://github.com/ckan/ckan/blob/{current_release_tag_value}/%s',
    'source for %s'
)}
